﻿<?LassoScript
/*
This demo illustrates how to place text blocks on a pdf using -> Add
with placement coordinates.
Notice that text is placed on the page using the text blocks upper left corner.

Author: Jolle Carlestam
Prepared for the Lasso Developer Conference in Chicago 2008
Use and alter freely but please keep a reference to where you found it
*/

//First set some vars holding basic data.
var('pagetype' = 'A4',
	'pageheight' = 842, // points
	'pagewidth' = 595);

// If you prefer US-Letter sized paper uncomment this section
/*
var('pagetype' = 'LETTER',
	'pageheight' = 792, // points
	'pagewidth' = 612);

*/

// Create the pdf_doc object
var( 'pdf' = pdf_doc( -size = $pagetype, -nocompress));

// Place a simple text snippet using coordinates.
var('text' = pdf_text( 'Notice that the text font is Helvetica plain.\rAnd that the leading is 16 points.\rThe text is placed at the very edge of the paper at the upper left corner. The first rows baseline placement is calculated by Lasso using the -top coordinate plus the leading height.'));

$pdf -> add( $text,
	-width = $pagewidth, // ! Without a -width param, -left & -top are ignored
	-left = 1,
	-top = 1);


// Place another text snippet using coordinates and within a box.
var('text' = pdf_text( 'This text is placed using a -height param as well as -width. That gives us a box that the text cannot flow outside. Notice that if not all of the text fits, surplus is simply cut off.'));

$pdf -> add( $text,
	-height = 70,
	-width = 200,
	-left = 100,
	-top = 100);

// Same text using a bigger "box"
$pdf -> add( $text,
	-height = 200,
	-width = 300,
	-left = 100,
	-top = 200);

// Place the same text again but this time add a -leading param.
// Leading adjusts the row height
$pdf -> add( $text,
	-height = 200,
	-width = 300,
	-left = 100,
	-top = 300,
	-leading = 30);


// Finally close the pdf_doc and serve it
$pdf -> close;
pdf_serve( -content = $pdf, -file = 'demo1.pdf');

?>